<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 01.10.2005

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $

$Revision: 1.16 $

Last locked:   $Date: 2011/02/25 15:27:35MEZ $

Last change by $Author: Michael Ziegel (zi82ot) $

History:
$Log: normalize-2-0-0.xsl  $
Revision 1.16 2011/02/25 15:27:35MEZ Michael Ziegel (zi82ot)
RemoveAttributes is switchable
Revision 1.15 2009/05/14 16:32:59CEST Michael Ziegel (zi82ot)
Member moved from DownUpTest/normalize-2-0-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to normalize-2-0-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Testing/DownUpTest/DownUpTest.pj.
Revision 1.14 2009/05/14 16:32:59CEST Michael Ziegel (zi82ot)
sort LZMappings
Revision 1.13 2009/01/21 16:03:13CET Michael Ziegel (zi82ot)
ASSIGNED_MTS_NODES
Revision 1.12 2009/01/20 12:44:08CET Michael Ziegel (zi82ot)
ASSIGNED_MTS_NODES
Revision 1.11 2008/03/25 16:11:31CET zi82ot
n
Revision 1.10 2008/03/19 15:28:35CET zi82ot
.
Revision 1.9 2008/02/08 14:34:48CET zi82ot
.
Revision 1.8 2008/02/07 13:44:42CET zi82ot
SBsRC used
Revision 1.7 2007/12/05 11:40:58CET zi82ot
drop NETINTERFACES of OPC_SERVER added by RAMV
Revision 1.6 2007/12/03 16:32:36CET zi82ot
next
Revision 1.5 2007/11/19 15:30:48CET zi82ot
process nodes
Revision 1.4 2007/09/26 12:48:31CEST zi82ot
bugs and extensions
Revision 1.3 2007/08/30 14:32:30CEST zi82ot
updated
Revision 1.2 2007/01/15 13:34:37CET zi82ot
Adapted to Network and FSP-structure
-->
  <xsl:include href="normalize-local-2-0-0.xsl"/>
  <xsl:param name="NetGroup" select="0"/>
  <xsl:param name="NetNode" select="'0'"/>
  <xsl:output method="xml" indent="yes"/>
  <!--****************  SELECTION of the parts which will be uploaded again  ***********************-->
  <!-- BEGIN -->
  <xsl:template match="EXPORTS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="EXPORTS">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <xsl:template match="IMPORTS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="IMPORTS">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- USED_SIS begin -->
  <xsl:template match="USED_SIS">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="USED_SI">
          <xsl:sort select="localID" data-type="text"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="CONNECTABLE">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup and count(*) != 0">
      <xsl:element name="CONNECTABLE">
        <xsl:if test="*">
          <xsl:apply-templates/>
        </xsl:if>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="ASSIGNED_OPCSVRS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="ASSIGNED_OPCSVRS">
        <xsl:if test="*">
          <xsl:apply-templates/>
        </xsl:if>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="ASSIGNED_MTS_NODES">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:if test="*">
        <xsl:element name="ASSIGNED_MTS_NODES">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="CONFIG_DATA">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="CONFIG_DATA">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- RPS adds empty element NET_INTERFACES to NODE of type OPC_SERVER -->
  <xsl:template match="NET_INTERFACES">
    <xsl:choose>
      <xsl:when test="../nodeType != 'OPC_SERVER'">
        <xsl:element name="NET_INTERFACES">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <!-- END -->
  <!-- cannot compare netLocalCRC  since upload knows only the value for the uploaded panel -->
  <xsl:template match="NODE/netLocalCRC">
    <xsl:element name="netLocalCRC">
      <xsl:text>NOT_COMPARED</xsl:text>
    </xsl:element>
  </xsl:template>
  <!-- END -->
  <!-- cannot compare netCRC  since upload knows only the value for the uploaded panel -->
  <xsl:template match="NODES/netCRC">
    <xsl:element name="netCRC">
      <xsl:text>NOT_COMPARED</xsl:text>
    </xsl:element>
  </xsl:template>
  <!-- END -->
  <xsl:template match="PANEL_COMMUNICATION">
    <xsl:choose>
    <xsl:when test="not(node())">
      <!-- delete if it does not have any nodes -->
    </xsl:when>
    <xsl:otherwise>
        <xsl:element name="{name()}">
            <xsl:value-of select="."/>
        </xsl:element>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:template>
  <!-- LZMappings sorted -->
    <xsl:template match="FTYPE_LZ_MAPPINGS">
    <xsl:element name="{name()}">
    <xsl:for-each select="*">
      <xsl:sort select="functionType"/>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- END -->
  <!-- LZMappings sorted -->
    <xsl:template match="CSTATES">
    <xsl:element name="{name()}">
    <xsl:for-each select="*">
      <xsl:sort select="compoundState"/>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- END -->
  <!-- LZMappings sorted -->
    <xsl:template match="LZ_ADIS">
    <xsl:element name="{name()}">
    <xsl:for-each select="*">
      <xsl:sort select="lz" data-type="number"/>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- END -->
</xsl:stylesheet>
